package gov.va.med.term.vhat.data.dto;

import java.util.ArrayList;
import java.util.List;

public class MapSetImportDTO extends NamedPropertiedItemImportDTO
{
	private String sourceCodeSystemName;
	private String sourceVersionName;
	private String targetCodeSystemName;
	private String targetVersionName;
	private List<MapEntryImportDTO> mapEntries = new ArrayList<>();
	private List<DesignationImportDTO> designations = new ArrayList<>();

	public MapSetImportDTO(String action, String name, String code, Long vuid, boolean active, String sourceCodeSystemName, String sourceVersionName,
			String targetCodeSystemName, String targetVersionName)
	{
		super(action, name, code, vuid, active);
		this.sourceCodeSystemName = sourceCodeSystemName;
		this.sourceVersionName = sourceVersionName;
		this.targetCodeSystemName = targetCodeSystemName;
		this.targetVersionName = targetVersionName;
	}

	public String getSourceCodeSystemName()
	{
		return sourceCodeSystemName;
	}

	public String getSourceVersionName()
	{
		return sourceVersionName;
	}

	public String getTargetCodeSystemName()
	{
		return targetCodeSystemName;
	}

	public String getTargetVersionName()
	{
		return targetVersionName;
	}

	public List<MapEntryImportDTO> getMapEntries()
	{
		return mapEntries;
	}

	public List<DesignationImportDTO> getDesignations()
	{
		return designations;
	}
}
